/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import javax.swing.SwingUtilities;
import net.espley.microprocessor.IBaseDevice;
import net.espley.processor.Computer;
import net.espley.processor.IOPorts;
import net.espley.processor.PaintAVCControl;
import net.espley.processor.PaintAVCData;
import net.espley.processor.PropertyStatus;
import net.espley.processor.devices.AVCDrawing;
import net.espley.processor.devices.AVCFrame;

public class AVC
implements IBaseDevice {
    private IOPorts io;
    private Computer computer;
    AVCFrame avcFrame;
    AVCDrawing drawing;
    static final int pageR = 1;
    static final int pageG = 2;
    static final int pageB = 4;
    static final int avcRows = 256;
    static final int avcColumnsSmall = 392;
    static final int avcColumnsLarge = 784;
    static final int memoryOffset = 2;
    static final int bytesPerLine = 49;
    static final int memorySize = 16384;
    static final int highResBit = 8;
    private boolean redSelected = false;
    private boolean greenSelected = false;
    private boolean blueSelected = false;
    private boolean redDisplay = false;
    private boolean greenDisplay = false;
    private boolean blueDisplay = false;
    private int memorySelected = 0;
    private int displaySelected = 0;
    private boolean highResSelected = false;
    private int lastB2 = 128;
    private boolean multiprocessor;
    private int[] red = new int[16384];
    private int[] green = new int[16384];
    private int[] blue = new int[16384];
    private Color[][] smallColourImage = new Color[256][392];
    private Color[][] largeColourImage = new Color[256][784];
    private Color[] palette = new Color[8];
    private int[] CRTCRegisters = new int[255];
    private int CRTCRegister = 0;
    private PaintAVCData paintAVCData;
    private PaintAVCControl paintAVCControl;
    private PaintAVCData pad = new PaintAVCData();

    public AVC(IOPorts io, Computer computer) {
        int column;
        int row;
        this.io = io;
        this.computer = computer;
        this.reset();
        this.avcFrame = new AVCFrame("Nascom 2 AVC Model B - Test Image");
        ((Component)this.avcFrame).setBounds(0, 0, 400, 288);
        this.drawing = new AVCDrawing();
        this.avcFrame.getContentPane().add((Component)this.drawing, "Center");
        this.avcFrame.getContentPane().setBounds(0, 0, 392, 256);
        ((Component)this.avcFrame).setVisible(true);
        for (row = 0; row < 256; ++row) {
            for (column = 0; column < 392; ++column) {
                this.smallColourImage[row][column] = new Color(row, 255 - row, column & 0xFF);
            }
        }
        for (row = 0; row < 256; ++row) {
            for (column = 0; column < 784; ++column) {
                this.largeColourImage[row][column] = new Color(row, 255 - row, column & 0xFF);
            }
        }
        this.paintAVCControl = new PaintAVCControl(this.drawing);
        this.paintAVCControl.setColourImageSmall(this.smallColourImage);
        this.paintAVCControl.setColourImageLarge(this.largeColourImage);
        this.multiprocessor = PropertyStatus.getInstance().getMultiprocessor();
        this.palette[0] = new Color(0, 0, 0);
        this.palette[1] = new Color(0, 0, 255);
        this.palette[2] = new Color(0, 255, 0);
        this.palette[3] = new Color(0, 255, 255);
        this.palette[4] = new Color(255, 0, 0);
        this.palette[5] = new Color(255, 0, 255);
        this.palette[6] = new Color(255, 255, 0);
        this.palette[7] = new Color(255, 255, 255);
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("Colour image complete.");
        }
        this.displayAVCImageSmall();
    }

    public boolean supportsMemoryReads() {
        return true;
    }

    public boolean supportsMemoryWrites() {
        return true;
    }

    public boolean supportsIOReads() {
        return true;
    }

    public boolean supportsIOWrites() {
        return true;
    }

    public final int memoryRead(int address) {
        address &= 0x3FFF;
        if (this.memorySelected != 1) {
            return 118;
        }
        if (this.redSelected) {
            return this.red[address];
        }
        if (this.greenSelected) {
            return this.green[address];
        }
        return this.blue[address];
    }

    public void memoryWrite(int address, int data) {
        address &= 0x3FFF;
        if (this.redSelected) {
            this.red[address] = data;
        }
        if (this.greenSelected) {
            this.green[address] = data;
        }
        if (this.blueSelected) {
            this.blue[address] = data;
        }
        if (this.highResSelected) {
            this.updatePixelByteHighRes(address, true);
        } else {
            this.updatePixelByteLowRes(address, true);
        }
    }

    public void resetMemoryDisplay() {
        for (int address = 0; address < 16384; ++address) {
            this.updatePixelByteLowRes(address, false);
            this.updatePixelByteHighRes(address, false);
        }
        if (this.highResSelected) {
            this.displayAVCImageLarge();
        } else {
            this.displayAVCImageSmall();
        }
    }

    public void updatePixelByteLowRes(int address, boolean byteWrite) {
        block5: {
            int column = address & 0x3F;
            int row = address >> 6 & 0xFF;
            if (column < 2 || column >= 51) {
                return;
            }
            column -= 2;
            column *= 8;
            int redByte = this.redDisplay ? 4 : 0;
            int greenByte = this.greenDisplay ? 2 : 0;
            int blueByte = this.blueDisplay ? 1 : 0;
            int bitPosition = 128;
            int redData = this.red[address];
            int blueData = this.blue[address];
            int greenData = this.green[address];
            boolean changed = false;
            for (int i = 0; i < 8; ++i) {
                int pixelValue = 0;
                if ((redData & bitPosition) != 0) {
                    pixelValue |= redByte;
                }
                if ((greenData & bitPosition) != 0) {
                    pixelValue |= greenByte;
                }
                if ((blueData & bitPosition) != 0) {
                    pixelValue |= blueByte;
                }
                bitPosition >>= 1;
                if (this.smallColourImage[row][column + i] == this.palette[pixelValue]) continue;
                this.smallColourImage[row][column + i] = this.palette[pixelValue];
                changed = true;
            }
            if (!byteWrite || !changed) break block5;
            this.displayAVCImageByte(row, column);
        }
    }

    public void updatePixelByteHighRes(int address, boolean byteWrite) {
        block7: {
            int column = address & 0x3F;
            int row = address >> 6 & 0xFF;
            if (column < 2 || column >= 51) {
                return;
            }
            column -= 2;
            column *= 16;
            int greenByte = this.greenDisplay ? 2 : 0;
            int blueByte = this.blueDisplay ? 1 : 0;
            int doubleBitPosition = 32768;
            int singleBitPosition = 128;
            int redGreenData = (this.green[address] << 8) + this.red[address];
            int blueData = this.blue[address];
            boolean changed = false;
            for (int i = 0; i < 8; ++i) {
                int pixelValue = 0;
                if ((redGreenData & doubleBitPosition) != 0) {
                    pixelValue |= greenByte;
                }
                if ((blueData & singleBitPosition) != 0) {
                    pixelValue |= blueByte;
                }
                doubleBitPosition >>= 1;
                if (this.largeColourImage[row][column + i + i] != this.palette[pixelValue]) {
                    this.largeColourImage[row][column + i + i] = this.palette[pixelValue];
                    changed = true;
                }
                pixelValue = 0;
                if ((redGreenData & doubleBitPosition) != 0) {
                    pixelValue |= greenByte;
                }
                if ((blueData & singleBitPosition) != 0) {
                    pixelValue |= blueByte;
                }
                doubleBitPosition >>= 1;
                singleBitPosition >>= 1;
                if (this.largeColourImage[row][column + i + i + 1] == this.palette[pixelValue]) continue;
                this.largeColourImage[row][column + i + i + 1] = this.palette[pixelValue];
                changed = true;
            }
            if (!byteWrite || !changed) break block7;
            this.displayAVCImageWord(row, column);
        }
    }

    public int IORead(int address) {
        switch (address) {
            case 176: {
                this.CRTCControlRead();
                break;
            }
            case 177: {
                this.CRTCDataRead();
                break;
            }
            case 178: {
                this.swapPagesRead();
            }
        }
        return 0;
    }

    private void CRTCControlRead() {
        this.io.writeByteDirect(176, this.CRTCRegister);
    }

    private void CRTCDataRead() {
        this.io.writeByteDirect(177, this.CRTCRegisters[this.CRTCRegister]);
    }

    private void swapPagesRead() {
        this.io.writeByteDirect(178, 0);
    }

    public void IOWrite(int address, int data) {
        switch (address) {
            case 176: {
                this.CRTCControlWrite(data);
                break;
            }
            case 177: {
                this.CRTCDataWrite(data);
                break;
            }
            case 178: {
                this.swapPagesWrite(data);
            }
        }
    }

    private void CRTCControlWrite(int data) {
        this.CRTCRegister = data;
    }

    private void CRTCDataWrite(int data) {
        this.CRTCRegisters[this.CRTCRegister] = data;
    }

    private void swapPagesWrite(int data) {
        this.memorySelected = 0;
        this.displaySelected = 0;
        this.redSelected = (data & 1) != 0;
        this.greenSelected = (data & 2) != 0;
        this.blueSelected = (data & 4) != 0;
        this.redDisplay = (data & 0x10) != 0;
        this.greenDisplay = (data & 0x20) != 0;
        this.blueDisplay = (data & 0x40) != 0;
        int temp = data & 7;
        switch (temp) {
            case 0: {
                this.memorySelected = 0;
                break;
            }
            case 1: {
                this.memorySelected = 1;
                break;
            }
            case 2: {
                this.memorySelected = 1;
                break;
            }
            case 4: {
                this.memorySelected = 1;
                break;
            }
            case 3: {
                this.memorySelected = 2;
                break;
            }
            case 5: {
                this.memorySelected = 2;
                break;
            }
            case 6: {
                this.memorySelected = 2;
                break;
            }
            case 7: {
                this.memorySelected = 3;
            }
        }
        temp = data >> 4 & 7;
        switch (temp) {
            case 0: {
                this.displaySelected = 0;
                break;
            }
            case 1: {
                this.displaySelected = 1;
                break;
            }
            case 2: {
                this.displaySelected = 1;
                break;
            }
            case 4: {
                this.displaySelected = 1;
                break;
            }
            case 3: {
                this.displaySelected = 2;
                break;
            }
            case 5: {
                this.displaySelected = 2;
                break;
            }
            case 6: {
                this.displaySelected = 2;
                break;
            }
            case 7: {
                this.displaySelected = 3;
                break;
            }
            default: {
                System.out.println("Bad AVC memory display value");
            }
        }
        if ((data & 0x78) != (this.lastB2 & 0x78)) {
            if ((data & 8) != 0) {
                if (!this.highResSelected) {
                    Point position = this.avcFrame.getLocationOnScreen();
                    this.avcFrame.dispose();
                    this.avcFrame = new AVCFrame("Nascom 2 AVC Model B - High Res Mode");
                    ((Component)this.avcFrame).setBounds(0, 0, 792, 288);
                    this.drawing = new AVCDrawing();
                    this.avcFrame.getContentPane().add((Component)this.drawing, "Center");
                    this.avcFrame.getContentPane().setBounds(0, 0, 784, 256);
                    this.paintAVCControl = new PaintAVCControl(this.drawing);
                    this.paintAVCControl.setColourImageSmall(this.smallColourImage);
                    this.paintAVCControl.setColourImageLarge(this.largeColourImage);
                    ((Component)this.avcFrame).setLocation(position);
                }
                this.highResSelected = true;
                this.resetMemoryDisplay();
                ((Component)this.avcFrame).setVisible(true);
            } else {
                if (this.highResSelected) {
                    Point position = this.avcFrame.getLocationOnScreen();
                    this.avcFrame.dispose();
                    this.avcFrame = new AVCFrame("Nascom 2 AVC Model B - Low Res Mode");
                    ((Component)this.avcFrame).setBounds(0, 0, 400, 288);
                    this.drawing = new AVCDrawing();
                    this.avcFrame.getContentPane().add((Component)this.drawing, "Center");
                    this.avcFrame.getContentPane().setBounds(0, 0, 392, 256);
                    this.paintAVCControl = new PaintAVCControl(this.drawing);
                    this.paintAVCControl.setColourImageSmall(this.smallColourImage);
                    this.paintAVCControl.setColourImageLarge(this.largeColourImage);
                    ((Component)this.avcFrame).setLocation(position);
                }
                this.highResSelected = false;
                this.resetMemoryDisplay();
                ((Component)this.avcFrame).setVisible(true);
            }
        }
        this.lastB2 = data;
    }

    public void reset() {
        int i;
        for (i = 0; i < this.CRTCRegisters.length; ++i) {
            this.CRTCRegisters[i] = 0;
        }
        this.redSelected = false;
        this.greenSelected = false;
        this.blueSelected = false;
        this.redDisplay = false;
        this.greenDisplay = false;
        this.blueDisplay = false;
        this.memorySelected = 0;
        this.displaySelected = 0;
        for (i = 0; i < this.red.length; ++i) {
            this.red[i] = 0;
            this.green[i] = 0;
            this.blue[i] = 0;
        }
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("AVC Reset");
        }
    }

    public boolean AVCMemorySelected() {
        return this.memorySelected != 0;
    }

    public boolean AVCDisplaySelected() {
        return this.displaySelected != 0;
    }

    public final void displayAVCImageSmall() {
        try {
            this.paintAVCControl.resetMode(false);
            SwingUtilities.invokeAndWait(this.paintAVCControl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void displayAVCImageLarge() {
        try {
            this.paintAVCControl.resetMode(true);
            SwingUtilities.invokeAndWait(this.paintAVCControl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void displayAVCImageByte(int row, int column) {
        try {
            if (this.multiprocessor) {
                SwingUtilities.invokeLater(new PaintAVCData(this.drawing, column, row, 8));
            } else {
                this.pad.setXY(this.drawing, column, row, 8);
                SwingUtilities.invokeAndWait(this.pad);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void displayAVCImageWord(int row, int column) {
        try {
            if (this.multiprocessor) {
                SwingUtilities.invokeLater(new PaintAVCData(this.drawing, column, row, 16));
            } else {
                this.pad.setXY(this.drawing, column, row, 16);
                SwingUtilities.invokeAndWait(this.pad);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        pageR = 1;
        pageG = 2;
        pageB = 4;
        avcRows = 256;
        avcColumnsSmall = 392;
        avcColumnsLarge = 784;
        memoryOffset = 2;
        bytesPerLine = 49;
        memorySize = 16384;
        highResBit = 8;
    }
}

