/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import net.espley.microprocessor.IBaseDevice;
import net.espley.microprocessor.IMemory;
import net.espley.microprocessor.Z80;
import net.espley.processor.AVC;
import net.espley.processor.Display;
import net.espley.processor.ExecuteZ80;
import net.espley.processor.FDC;
import net.espley.processor.IOPorts;
import net.espley.processor.Keyboard;
import net.espley.processor.Memory64k;
import net.espley.processor.NMI;
import net.espley.processor.Pio;
import net.espley.processor.PropertyStatus;
import net.espley.processor.RegisterFrame;
import net.espley.processor.Uart;
import net.espley.processor.VideoROM;
import net.espley.processor.devices.GUIListener;
import net.espley.processor.devices.ScreenFrame;

public class Computer {
    private Z80 z80;
    private Memory64k ram;
    private IOPorts io;
    private VideoROM videoROM;
    private Keyboard keyboard;
    private Uart uart;
    private Pio pio;
    private NMI nmi;
    private AVC avc;
    private FDC fdc;
    private ExecuteZ80 executeZ80;
    private GUIListener guiListener = new GUIListener();
    private RegisterFrame registerFrame;
    private Display display;
    private Thread z80Thread;

    public Computer() {
        this.guiListener.setComputer(this);
        this.ram = new Memory64k();
        this.io = new IOPorts();
        this.z80 = new Z80((IMemory)this.ram, (IBaseDevice)this.io);
        this.videoROM = new VideoROM();
        this.keyboard = new Keyboard(this.io);
        this.uart = new Uart(this.io);
        this.pio = new Pio(this.io);
        this.display = new Display(this.keyboard, this.videoROM, this.guiListener, this, this.z80);
        this.avc = new AVC(this.io, this);
        this.fdc = new FDC(this.io);
        this.nmi = new NMI(this);
        ScreenFrame frame = this.display.getScreenFrame();
        this.ram.setProcessor(this.z80);
        this.ram.setDisplay(this.display);
        this.ram.setAVC(this.avc);
        this.ram.setFrame(frame);
        this.fdc.setFrame(frame);
        this.guiListener.setFDC(this.fdc);
        this.ram.loadROM("Nassys3.nas", true);
        this.io.addDevice(this.keyboard);
        this.io.addDevice(this.uart);
        this.io.addDevice(this.nmi);
        this.io.addDevice(this.avc);
        this.io.addDevice(this.fdc);
        this.executeZ80 = new ExecuteZ80();
        this.registerFrame = new RegisterFrame();
    }

    public final void singleStep() {
        this.executeZ80.setRun(true);
        this.executeZ80.setProcessor(this.z80, 1, 0);
        this.z80Thread = new Thread(this.executeZ80);
        this.z80Thread.start();
    }

    public final void forever() {
        this.executeZ80.setRun(true);
        this.executeZ80.setProcessor(this.z80, 2, 0);
        this.z80Thread = new Thread(this.executeZ80);
        this.z80Thread.start();
        this.registerFrame.showRegisters(this.z80);
    }

    public final void runUntil(int address) {
        this.executeZ80.setRun(true);
        this.executeZ80.setProcessor(this.z80, 3, address);
        this.z80Thread = new Thread(this.executeZ80);
        this.z80Thread.start();
    }

    public final void halt() {
        this.executeZ80.setRun(false);
        this.registerFrame.showRegisters(this.z80);
    }

    public final void yield() {
        Thread.yield();
    }

    public void resetPC(int pc) {
        this.z80.setProgramCounter(pc);
    }

    public void reset() {
        PropertyStatus.getInstance().reset();
        this.keyboard.reset();
        this.z80.reset();
        this.registerFrame.showRegisters(this.z80);
    }

    public void loadFile(String fileName, boolean readOnly) {
        this.ram.loadROM(fileName, readOnly);
    }

    public void dumpMemory(String fileName) {
        this.ram.dumpMemory(fileName);
    }

    public void setNMI() {
        this.executeZ80.requestSingleStepNMI();
    }

    public void set2MHz() {
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("2 MHz");
        }
        this.z80.setMHz(2);
    }

    public void set4MHz() {
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("4 MHz");
        }
        this.z80.setMHz(4);
    }

    public void setMHzMax() {
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("Max MHz");
        }
        this.z80.setMHz(0);
    }
}

