/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import java.io.FileWriter;
import javax.swing.JOptionPane;
import net.espley.processor.Memory64k;
import net.espley.processor.Utility;
import net.espley.processor.devices.ScreenFrame;

public class DataFileWriter {
    String fileName;
    ScreenFrame frame;

    public DataFileWriter(String fileName) {
        this.fileName = fileName;
    }

    public void setFrame(ScreenFrame frame) {
        this.frame = frame;
    }

    public void dumpMemory(Memory64k memory) {
        Utility utility = new Utility();
        int checksum = 0;
        try {
            FileWriter sink = new FileWriter(this.fileName);
            for (int address = 0; address < 65536; address += 8) {
                checksum = (address >> 8) + (address & 0xFF);
                sink.write(String.valueOf(String.valueOf(utility.getWord(address))).concat(" "));
                for (int column = 0; column < 8; ++column) {
                    int data = memory.readByte(address + column);
                    checksum += data;
                    sink.write(String.valueOf(String.valueOf(utility.getByte(data))).concat(" "));
                }
                sink.write(utility.getByte(checksum & 0xFF));
                sink.write(0);
                sink.write(0);
                sink.write(13);
            }
            sink.close();
        }
        catch (Exception e) {
            System.out.println("Unable to write file ".concat(String.valueOf(String.valueOf(e))));
            JOptionPane.showMessageDialog(this.frame, "Unable to write the file:\n".concat(String.valueOf(String.valueOf(this.fileName))), "Write File", 0);
        }
    }
}

