/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import net.espley.microprocessor.IBaseDevice;
import net.espley.processor.IOPorts;
import net.espley.processor.PropertyStatus;
import net.espley.processor.Utility;

public class Keyboard
implements IBaseDevice {
    private int position;
    private static final int resetMask = 2;
    private static final int incMask = 1;
    private static final int bufLen = 9;
    private static IOPorts io;
    private long keyPressTime = 0L;
    private static int[][] keyTable;
    private static int[] bufferEmpty;
    private static int[] buffer;
    private static int[] localBfr;
    private static final int shiftBit = 32;
    private static final int ctrlBit = 64;
    private static final int graphBit = 128;
    private static final int shiftByte = 239;
    private static final int ctrlByte = 247;
    private static final int graphByte = 247;
    private boolean keyAvailable = false;
    private int keyTime = PropertyStatus.getInstance().getKeyTime();
    Utility util;

    Keyboard(IOPorts io) {
        Keyboard.io = io;
        this.reset();
    }

    public boolean supportsIOReads() {
        return true;
    }

    public boolean supportsIOWrites() {
        return true;
    }

    public int IORead(int address) {
        if (address == 0) {
            io.writeByteDirect(0, buffer[this.position]);
        }
        return 0;
    }

    public synchronized void IOWrite(int address, int data) {
        if (address == 0) {
            if ((2 & data) == 2) {
                this.position = 0;
                long timeGap = System.currentTimeMillis() - this.keyPressTime;
                if (timeGap > (long)this.keyTime) {
                    this.resetBuffer();
                }
                if (this.keyAvailable) {
                    System.arraycopy(localBfr, 0, buffer, 0, localBfr.length);
                }
            } else if ((1 & data) == 1) {
                this.position = (this.position + 1) % 9;
            }
        }
    }

    public void reset() {
        int i;
        this.position = 0;
        System.arraycopy(bufferEmpty, 0, buffer, 0, bufferEmpty.length);
        for (i = 0; i < keyTable.length; ++i) {
            System.arraycopy(buffer, 0, keyTable[i], 0, buffer.length);
        }
        Keyboard.keyTable[64][0] = 223;
        Keyboard.keyTable[65][4] = 239;
        Keyboard.keyTable[66][1] = 253;
        Keyboard.keyTable[67][7] = 247;
        Keyboard.keyTable[68][2] = 247;
        Keyboard.keyTable[69][3] = 247;
        Keyboard.keyTable[70][1] = 247;
        Keyboard.keyTable[71][7] = 254;
        Keyboard.keyTable[72][1] = 254;
        Keyboard.keyTable[73][4] = 223;
        Keyboard.keyTable[74][2] = 254;
        Keyboard.keyTable[75][3] = 254;
        Keyboard.keyTable[76][4] = 254;
        Keyboard.keyTable[77][3] = 253;
        Keyboard.keyTable[78][2] = 253;
        Keyboard.keyTable[79][5] = 223;
        Keyboard.keyTable[80][6] = 223;
        Keyboard.keyTable[81][5] = 239;
        Keyboard.keyTable[82][7] = 223;
        Keyboard.keyTable[83][3] = 239;
        Keyboard.keyTable[84][1] = 223;
        Keyboard.keyTable[85][3] = 223;
        Keyboard.keyTable[86][7] = 253;
        Keyboard.keyTable[87][4] = 247;
        Keyboard.keyTable[88][1] = 239;
        Keyboard.keyTable[89][2] = 223;
        Keyboard.keyTable[90][2] = 239;
        Keyboard.keyTable[91][6] = 191;
        Keyboard.keyTable[92][0] = 255;
        Keyboard.keyTable[93][7] = 191;
        Keyboard.keyTable[94][0] = 255;
        for (i = 64; i < 96; ++i) {
            System.arraycopy(keyTable[i], 0, keyTable[i + 32], 0, bufferEmpty.length);
            Keyboard.keyTable[i + 32][0] = 239;
            Keyboard.keyTable[i + 32][8] = 239;
        }
        for (i = 64; i < 96; ++i) {
            if (i - 64 == 27) continue;
            System.arraycopy(keyTable[i], 0, keyTable[i - 64], 0, bufferEmpty.length);
            Keyboard.keyTable[i - 64][0] = 247;
            Keyboard.keyTable[i - 64][8] = 247;
        }
        Keyboard.keyTable[32][7] = 239;
        Keyboard.keyTable[44][4] = 253;
        Keyboard.keyTable[45][8] = 251;
        Keyboard.keyTable[46][5] = 253;
        Keyboard.keyTable[47][6] = 253;
        Keyboard.keyTable[48][6] = 251;
        Keyboard.keyTable[49][6] = 239;
        Keyboard.keyTable[50][6] = 247;
        Keyboard.keyTable[51][5] = 247;
        Keyboard.keyTable[52][7] = 251;
        Keyboard.keyTable[53][1] = 251;
        Keyboard.keyTable[54][2] = 251;
        Keyboard.keyTable[55][3] = 251;
        Keyboard.keyTable[56][4] = 251;
        Keyboard.keyTable[57][5] = 251;
        Keyboard.keyTable[58][6] = 254;
        Keyboard.keyTable[59][5] = 254;
        Keyboard.keyTable[60][0] = 239;
        Keyboard.keyTable[60][4] = 253;
        Keyboard.keyTable[62][0] = 239;
        Keyboard.keyTable[62][5] = 253;
        Keyboard.keyTable[63][0] = 239;
        Keyboard.keyTable[63][6] = 253;
        Keyboard.keyTable[92][0] = 239;
        Keyboard.keyTable[92][6] = 191;
        Keyboard.keyTable[95][0] = 239;
        Keyboard.keyTable[95][7] = 191;
        Keyboard.keyTable[27][0] = 239;
        Keyboard.keyTable[27][8] = 253;
        Keyboard.keyTable[43][0] = 239;
        Keyboard.keyTable[43][5] = 254;
        Keyboard.keyTable[33][0] = 239;
        Keyboard.keyTable[33][6] = 239;
        Keyboard.keyTable[34][0] = 239;
        Keyboard.keyTable[34][6] = 247;
        Keyboard.keyTable[35][0] = 239;
        Keyboard.keyTable[35][5] = 247;
        Keyboard.keyTable[36][0] = 239;
        Keyboard.keyTable[36][7] = 251;
        Keyboard.keyTable[37][0] = 239;
        Keyboard.keyTable[37][1] = 251;
        Keyboard.keyTable[94][0] = 239;
        Keyboard.keyTable[94][6] = 251;
        Keyboard.keyTable[38][0] = 239;
        Keyboard.keyTable[38][2] = 251;
        Keyboard.keyTable[42][0] = 239;
        Keyboard.keyTable[42][6] = 254;
        Keyboard.keyTable[40][0] = 239;
        Keyboard.keyTable[40][4] = 251;
        Keyboard.keyTable[41][0] = 239;
        Keyboard.keyTable[41][5] = 251;
        Keyboard.keyTable[61][0] = 239;
        Keyboard.keyTable[61][8] = 235;
        Keyboard.keyTable[39][0] = 239;
        Keyboard.keyTable[39][3] = 251;
        Keyboard.keyTable[128][6] = 191;
        Keyboard.keyTable[129][0] = 239;
        Keyboard.keyTable[130][0] = 247;
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("Keyboard reset");
        }
    }

    public synchronized void resetBuffer() {
        System.arraycopy(bufferEmpty, 0, buffer, 0, bufferEmpty.length);
        this.keyAvailable = false;
    }

    public synchronized void setKeyStroke(int value) {
        this.keyPressTime = System.currentTimeMillis();
        if (value < 0) {
            switch (value) {
                case -1: {
                    value = 128;
                    break;
                }
                case -2: {
                    value = 129;
                    break;
                }
                case -3: {
                    value = 130;
                }
            }
        }
        System.arraycopy(keyTable[value], 0, localBfr, 0, localBfr.length);
        this.keyAvailable = true;
    }

    static {
        resetMask = 2;
        incMask = 1;
        bufLen = 9;
        keyTable = new int[256][9];
        bufferEmpty = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255};
        buffer = new int[9];
        localBfr = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255};
        shiftBit = 32;
        ctrlBit = 64;
        graphBit = 128;
        shiftByte = 239;
        ctrlByte = 247;
        graphByte = 247;
    }
}

