/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import java.io.File;
import net.espley.microprocessor.IMemory;
import net.espley.microprocessor.Z80;
import net.espley.processor.AVC;
import net.espley.processor.DataFileReader;
import net.espley.processor.DataFileWriter;
import net.espley.processor.Display;
import net.espley.processor.PropertyStatus;
import net.espley.processor.Utility;
import net.espley.processor.devices.ScreenFrame;

class Memory64k
implements IMemory {
    protected final int memorySize = 65536;
    protected final int maxAddress = 65535;
    private int[] memory = new int[65536];
    private boolean[] rom = new boolean[65536];
    private boolean warning = PropertyStatus.getInstance().getROMWarning();
    private Display display;
    private AVC avc;
    private Z80 z80;
    private ScreenFrame frame;
    Utility util;

    public Memory64k() {
        this.reset();
    }

    public void setFrame(ScreenFrame frame) {
        this.frame = frame;
    }

    protected void setProcessor(Z80 z80) {
        this.z80 = z80;
    }

    protected void setAVC(AVC avc) {
        this.avc = avc;
    }

    protected void setDisplay(Display display) {
        this.display = display;
    }

    protected void loadROM(String fileName, boolean readOnly) {
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("Loading File : ".concat(String.valueOf(String.valueOf(fileName))));
        }
        DataFileReader reader = new DataFileReader(new File(fileName), readOnly);
        reader.setFrame(this.frame);
        reader.readFile(this);
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("File Loaded");
        }
    }

    protected void dumpMemory(String fileName) {
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("Saving File : ".concat(String.valueOf(String.valueOf(fileName))));
        }
        DataFileWriter writer = new DataFileWriter(fileName);
        writer.setFrame(this.frame);
        writer.dumpMemory(this);
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("File Saved");
        }
    }

    public final int readByte(int address) {
        switch (address & 0xC000) {
            case 0: {
                return this.memory[address];
            }
            case 16384: {
                return this.memory[address];
            }
            case 32768: {
                if (this.avc.AVCMemorySelected()) {
                    return this.avc.memoryRead(address);
                }
                return this.memory[address];
            }
            case 49152: {
                return this.memory[address];
            }
        }
        return 118;
    }

    public final int readByteDirect(int address) {
        return this.memory[address];
    }

    public final int readWord(int address) {
        return this.readByte(address) + this.readByte(address + 1 & 0xFFFF) * 256;
    }

    public final int readWordDirect(int address) {
        return this.readByteDirect(address) + this.readByteDirect(address + 1 & 0xFFFF) * 256;
    }

    public final void writeByte(int address, int data) {
        if (this.rom[address]) {
            if (this.warning) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Attempt to write to ROM at ").append(this.util.getWord(address)).append("H").append(", @ ").append(this.util.getWord(this.z80.getProgramCounter())))));
            }
        } else {
            switch (address & 0xC000) {
                case 0: {
                    this.memory[address] = data;
                    this.display.writeByte(address, data);
                    break;
                }
                case 16384: {
                    this.memory[address] = data;
                    break;
                }
                case 32768: {
                    if (this.avc.AVCMemorySelected()) {
                        this.avc.memoryWrite(address, data);
                        break;
                    }
                    this.memory[address] = data;
                    break;
                }
                case 49152: {
                    this.memory[address] = data;
                }
            }
        }
    }

    public final void writeByteDirect(int address, int data) {
        this.memory[address] = data;
    }

    public final void setReadStatus(int address, boolean readOnly) {
        this.rom[address] = readOnly;
    }

    public final void writeWord(int address, int data) {
        this.writeByte(address, data & 0xFF);
        address = address + 1 & 0xFFFF;
        this.writeByte(address, data >>>= 8);
    }

    public final void writeWordDirect(int address, int data) {
        this.writeByteDirect(address, data & 0xFF);
        address = address + 1 & 0xFFFF;
        this.writeByteDirect(address, data >>>= 8);
    }

    public void reset() {
        for (int i = 0; i < 65536; ++i) {
            this.memory[i] = 0;
            this.rom[i] = false;
        }
        this.util = new Utility();
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("Memory space reset");
        }
    }
}

